<?php

return [
    'types'  => [
        'news'       => [
            'category' => 'news_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'events'     => [
            'category' => 'events_categories',
            'comments' => false,
            'likes'    => true,
        ],
        'jobs_offers' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => false,
        ],
        'spaces' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'spaces_pages' => [
            'category' => 'pages_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'pages' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'blocks' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ]
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL') . '/edit/' . class_to_type($model) . '/' . $model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'     => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'authentication' => [
            'headers' => [],
        ],
    ],
];
