<?php

return [
    'build_url_callbacks' => [
        'jobs_offers' => function ($model) {
            $pageName = match ($model->langcode) {
                'nl' => "banen",
                default => "offres-emploi",
            };

            return "$model->langcode/$pageName?modal=job-offers&contentType=jobs_offers&uuid=$model->uuid&size=m";
        },
        'ged' => function ($model) {
            $baseGED = match ($model->langcode) {
                'nl' => 'nl/bibliotheek?folder=',
                default => 'fr/bibliotheque?folder=',
            };

            return match ($model->content_type) {
                'folders' => $baseGED . $model->uuid,
                'documents' => $baseGED . $model->folders->first()->uuid,
                default => data_get($model, 'slug.0'),
            };
        }
    ],
    'manual_notifications' => [
        'enabled' => env('INSIDE_MANUAL_NOTIFICATION_ENABLED', false),
        'disabled_types' => [
            'newsletters',
            'groups',
            'users',
        ],
        'enabled_types' => is_string($enabledTypes = env('INSIDE_MANUAL_NOTIFICATION_TYPES', []))
            ? explode(',', $enabledTypes)
            : $enabledTypes,
        'contents_url_field' => [
            'external_notifications' => 'external_notif_link',
        ],
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo',
                ],
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo',
                ],
            ],
            'external_notifications' => [
                'fields' => [
                    'image',
                ],
            ],
        ],
        'custom_url' => function ($channel, $type, $uuid) {
            return match ($type) {
                'jobs_offers' => 'CUSTOM:jobs_offers',
                'documents','folders' => 'CUSTOM:ged',
                default => null,
            };
        },
    ],
];
