<?php

use Carbon\Exceptions\InvalidFormatException;
use Illuminate\Support\Carbon;
use Inside\Host\Bridge\BridgeContent;
use Inside\User\Models\User;

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'upn' => 'userPrincipalName',
        'link_teams' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->userPrincipalName",
        'image' => fn (mixed $user) => avatar($user->photo, User::query()->where('email', $user->mail)->first()),
        'birthday' => fn (mixed $user) => $user->onPremisesExtensionAttributes && $user->onPremisesExtensionAttributes->extensionAttribute1
                ? carbonize('d/m/Y')->from($user->onPremisesExtensionAttributes->extensionAttribute1)->birthday()
                : null,
        'phone' => fn (mixed $user) => $user->mobilePhone ?? null,
        'entities' => fn (mixed $user) => reference('entities')->from($user->companyName)->get(),
        'functions' => fn (mixed $user) => reference('functions')->from($user->jobTitle)->get(),
        'departments' => fn (mixed $user) => reference('departments')->from($user->department)->get(),
        'locations' => fn (mixed $user) => reference('locations')->from($user->officeLocation)->get(),
        'status' => fn () => 1,
    ],
    'custom_attributes' => [
    ],
];
