<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

final class SetUsersDefaultBirthday extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'birthday', [
            'name' => 'birthday',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'editable' => false,
            'title' => [
                'fr' => 'Anniversaire',
                'nl' => 'Verjaardag',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => null,
        ]);

        $bridgeContent = new BridgeContent();

        Users::whereYear('birthday', '>=', 2023)
            ->pluck('uuid')
            ->each(fn (string $uuid) => $bridgeContent->contentUpdate('users', ['uuid' => $uuid, 'birthday' => null]));
    }
}
