<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

final class DeleteUserBusinessPhoneContent extends Migration
{
    public function up(): void
    {
        $contentBridge = new BridgeContent();

        Users::each(function (Users $user) use ($contentBridge) {
            if (!$user->phone) {
                return;
            }

            $contentBridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'phone' => '',
            ]);
        });
    }
}
