<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Collection;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateEntitiesCardinality extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $contentTypes = collect(Schema::getModelsWithField('entities'));

        $existingReferences = $contentTypes->mapWithKeys(function (string $contentType) {
            $references = type_to_class($contentType)::all()
                ->mapWithKeys(fn (mixed $content) => [$content->uuid => $content->entities?->pluck('uuid')->values()->all()])
                ->filter();

            return [$contentType => $references];
        });

        $contentTypes->each(fn ($contentType) => match ($contentType) {
            'users' => $this->getBridge()?->contentTypeDeleteField('user', 'user', 'entities'),
            default => $this->getBridge()?->contentTypeDeleteField('node', $contentType, 'entities')
        });

        $entitiesField = [
            'name' => 'entities',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'title' => [
                'fr' => 'Entités',
                'nl' => 'Entiteiten',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['entities'],
                'cardinality' => -1,
            ],
        ];

        $contentTypes->each(fn ($contentType) => $this->getBridge()?->contentTypeCreateOrUpdateField($contentType, 'entities', $entitiesField));

        $bridgeContent = new BridgeContent();

        $existingReferences->each(function (Collection $references, string $contentType) use ($bridgeContent) {
            $references->each(fn (array $entities, string $uuid) => $bridgeContent->contentUpdate($contentType, ['uuid' => $uuid, 'entities' => $entities]));
        });

        $this->finishUp();
    }
}
