<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class FixDefaultTools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $tools = collect([
            'Teams',
            'Offres d\'emploi',
            'Annuaire',
            'Mon quotidien',
        ]);

        $defaultTools = Tools::query()
            ->whereIn('title', $tools)
            ->where('langcode', 'fr')
            ->get()
            ->sortBy(fn (Tools $tool) => $tools->search($tool->title))
            ->map(function (Tools $tool) {
                $translation = $tool->getTranslationIfExists('nl');

                if ($translation->uuid === $tool->uuid) {
                    $translation = null;
                }

                return [
                    'fr' => $tool->uuid,
                    'nl' => $translation?->uuid,
                    'uuid_host' => $tool->uuid_host,
                ];
            });

        $this->getBridge()?->contentTypeCreateOrUpdateField('users', 'tools', [
            'default' => $defaultTools->pluck('uuid_host')->map(fn (string $uuid_host) => ['target_uuid' => $uuid_host])->values()->all(),
        ]);

        $bridge = new BridgeContent();

        Users::all()
            ->each(function (Users $user) use ($defaultTools, $bridge) {
                $userTools = $user->tools->pluck('uuid');
                $tools = $defaultTools->pluck($user->langcode)->merge($userTools)->filter()->unique()->values()->all();

                $bridge->contentUpdate('users', ['uuid' => $user->uuid, 'tools' => $tools]);
            });

        $this->finishUp();
    }
}
