<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdatePagesTitle extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeUpdate('pages', [
            'title' => [
                'fr' => 'Page simple',
                'nl' => 'Eenvoudige pagina',
            ],
        ]);
        $this->finishUp();
    }
}
