<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Models\Model;
use Inside\Host\Migrations\CreateContentTypes;

final class AddMissingTranslations extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $titles = collect([
            'documents' => [
                'fr' => 'Document',
                'nl' => 'Document',
            ],
            'folders' => [
                'fr' => 'Dossier',
                'nl' => 'Map',
            ],
            'dms_link' => [
                'fr' => 'Lien',
                'nl' => 'Link',
            ],
            'movements_categories' => [
                'fr' => 'Catégorie de mouvement',
                'nl' => 'Categorie Bewegingen',
            ],
            'movements' => [
                'fr' => 'Mouvement',
                'nl' => 'Beweging',
            ],
            'pages' => [
                'fr' => 'Page publique',
                'nl' => 'Openbare pagina',
            ],
            'marker' => [
                'fr' => 'Implantations',
                'nl' => 'Plaats',
            ],
            'comments' => [
                'fr' => 'Commentaire',
                'nl' => 'Opmerking',
            ],
        ]);


        $titles->each(function ($title, $contentType) {
            $this->getBridge()?->contentTypeUpdateOrCreate($contentType, ['title' => $title]);
        });

        $this->getBridge()?->changeFieldTitle('dms_link', 'folders', [
            'fr' => 'Dossier parent',
            'nl' => 'Bovenliggende map',
        ]);

        collect(['admin_menus', 'footer_menus', 'main_menus', 'shortcuts_menus', 'tools_menus'])
            ->each(function (string $menuType) {
                Model::where('class', type_to_class($menuType))->delete();
                Schema::dropIfExists(type_to_table($menuType));
            });

        $this->finishUp();
    }
}
