import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
