<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class MakeTabsPagesSearchable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->updateContentTypeOptions('tabs_pages', [
            'searchable' => true,
            'global_searchable' => true
        ]);

        $bridge->updateFieldOptions(
            type: 'tabs_pages',
            fieldName: 'content',
            options: [
                'searchable' => true
            ]
        );
        Artisan::call('index:rebuild:missing');
    }
}
