<?php

use Adldap\Models\Entry;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;

return [
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'userprincipalname',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'function' => 'title',
        'phone' => 'telephonenumber',
        'mobile_phone' => 'mobile',
        'services' => fn (Entry $user) => collect($user->getAttribute('department'))->map(
            fn ($department) => reference('services')->from($department)->get()
        )->flatten()->all(),
        'territories' => fn (Entry $user) => collect($user->getAttribute('st'))->map(
            fn ($territory) => reference('territories')->from($territory)->get()
        )->flatten()->all(),
        'municipalities' => fn (Entry $user) => collect($user->getAttribute('l'))->map(
            fn ($municipality) => reference('municipalities')->from($municipality)->get()
        )->flatten()->all(),
        'users' => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            $managerLdapAttributes = $user->getFirstAttribute('manager');
            if (empty($managerLdapAttributes)) {
                return null;
            }
            $managerLdapAttributes = explode(',', $managerLdapAttributes);
            $managerNames = [];
            foreach ($managerLdapAttributes as $managerLdapAttribute) {
                $managerLdapAttribute = explode('=', $managerLdapAttribute);
                if ($managerLdapAttribute[0] !== 'CN') {
                    continue;
                }
                $managerNames[] = $managerLdapAttribute[1];
            }
            if (empty($managerNames)) {
                return null;
            }
            $managers = [];
            foreach ($managerNames as $managerName) {
                $manager = Users::whereRaw("CONCAT(firstname, ' ', lastname) LIKE ?", ["%{$managerName}%"])
                    ->first();
                if ($manager) {
                    $managers[] = $manager->uuid;
                }
            }
            if (empty($managers)) {
                return null;
            }
            return $managers;
        },
    ]
];
