<?php

$customConnectionOptions = [];
if (env('ADLDAP_DONT_CHECK_TLS_CERTIFICAT', false)) {
    $customConnectionOptions[LDAP_OPT_X_TLS_REQUIRE_CERT] = LDAP_OPT_X_TLS_NEVER;
}

return [
    'logging' => env('ADLDAP_LOGGING', false),
    'connections' => [
        'default' => [
            'auto_connect' => env('ADLDAP_AUTO_CONNECT', true),
            'connection' => Adldap\Connections\Ldap::class,
            'settings' => [
                'schema' => Adldap\Schemas\ActiveDirectory::class,
                'account_prefix' => env('ADLDAP_ADMIN_ACCOUNT_PREFIX', ''),
                'account_suffix' => env('ADLDAP_ADMIN_ACCOUNT_SUFFIX', ''),
                'hosts' => explode(' ', env('ADLDAP_CONTROLLERS', 'staging.maecia.com')),
                'port' => env('ADLDAP_PORT', 389),
                'timeout' => env('ADLDAP_TIMEOUT', 5),
                'base_dn' => env('ADLDAP_BASE_DN', 'dc=corp,dc=acme,dc=org'),
                'username' => env(
                    'ADLDAP_ADMIN_USERNAME',
                    'cn=ndeniaud,ou=External,dc=staging2,dc=maecia,dc=com'
                ),
                'password' => env('ADLDAP_ADMIN_PASSWORD', 'maecia'),
                'follow_referrals' => false,
                'use_ssl' => env('ADLDAP_USE_SSL', false),
                'use_tls' => env('ADLDAP_USE_TLS', false),
                'custom_options' => $customConnectionOptions,
            ],
        ],
    ],
];
