import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-administration': {
    disabledAdvancedSettingsFields: ['ged_enable_likes']
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-users': {
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    allowAvatarEdition: false,
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'mobile_phone',
          'function',
          'image'
        ]
      }
    }
  }
}
