<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class SetFaqAsGlobalSearchable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        collect(['faq_categories', 'faq_questions'])
            ->each(fn ($contentType) => $this->updateContentType($contentType, $bridge));
    }

    private function updateContentType(string $contentType, BridgeContentType $bridge): void
    {
        $bridge->updateContentTypeOptions($contentType, [
            'searchable' => true,
            'global_searchable' => true
        ]);
        Artisan::call('index:rebuild', ['--type' => $contentType]);
    }
}
