<?php

return [
    'postfilter' => function ($users) {
        return $users->filter(
            fn (mixed $user) =>
            $user->accountEnabled &&
            !blank($user->companyName) &&
            !blank($user->userPrincipalName) &&
            !blank($user->mail) &&
            str($user->mail)->contains(['@ga.fr', '@sight-studio.fr', '@rooj.fr', '@ga-sa.fr']) &&
            $user->onPremisesExtensionAttributes->extensionAttribute1 === 'user'
        );
    },
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'image' => 'photo',
        'mobile_phone' => 'mobilePhone',
        'upn' => 'userPrincipalName',
        'phone' => fn (mixed $user) => $user->businessPhones[0],
        'function' => 'jobTitle',
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from(ucfirst($user->department))
            ->get(),
        'companies' => fn (mixed $user) => reference('companies')
            ->identifiedBy('code')
            ->from(ucfirst($user->companyName))
            ->get(),
        'locations' => fn (mixed $user) => reference('locations')
            ->identifiedBy('code')
            ->from(ucfirst($user->officeLocation))
            ->get(),
        'managers' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->first(),
        'status' => fn () => 1,
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ],
];
