<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class ReplaceLocalisationsByLocations extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $bridgeContentType = new BridgeContentType();

        // remove localisations
        $bridgeContentType->contentTypeDelete('localisations');
        $bridgeContentType->contentTypeDeleteField('user', 'user', 'localisations');

        // add content type locations
        $bridgeContentType->contentTypeCreate('locations', [
            'name' => 'locations',
            'translatable' => true,
            'searchable' => true,
            'global_searchable' => false,
            'aliasable' => false,
            'permissible' => false,
            'categorizable' => false,
            'listing_type' => 'hidden',
            'title' => [
                'fr' => 'Localisation',
            ],
        ], [
            [
                'name' => 'code',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'code',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        ]);

        // add field locations
        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'locations', [
            'name' => 'locations',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'editable' => true,
            'weight' => 18,
            'title' => [
                'fr' => 'Localisation',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 18,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => -1,
            ],
        ]);

        $this->finishUp();
        Artisan::call("models:rebuild");
    }
}
