<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Layout\Models\LayoutPath;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Forms;
use Inside\Settings\Models\Setting;
use Illuminate\Support\Facades\DB;
use Inside\Layout\Repositories\Contracts\LayoutRepositoryInterface;

class CleaningAfterRemovingInsideForms extends Migration
{
    public const TABLES_TO_DELETE = ['inside_forms_answers', 'inside_forms_answers_logs', 'inside_forms_answers',
        'inside_forms_submissions', 'inside_forms_answers'];
    public const MIGRATIONS_TO_DELETE = [
        '2018_11_29_000000_create_forms_answers_table', '2018_11_29_000001_remove_field_type_to_answers_table',
        '2018_12_13_000000_create_forms_answers_logs_table', '2018_12_27_000000_drop_forms_answers_logs_table',
        '2018_12_27_000001_drop_forms_answers_table', '2018_12_27_000002_create_forms_submissions_table',
        '2018_12_27_000003_refactor_forms_answers_table', '2018_12_27_000004_refactor_forms_answers_logs_table',
        '2019_01_03_000000_add_notify_field_to_forms_submissions_table',
        '2019_01_16_000000_add_status_field_to_forms_submissions_table',
        '2019_01_17_000000_add_default_value_to_status_field_in_forms_submissions_table',
        '2019_07_25_000000_change_status_type_field_in_forms_submissions_table',
        '2019_10_01_000000_update_form_to_v2', '2020_01_24_000000_ehance_forms_mail_notifications',
        '2020_06_03_000000_add_status_notifications', '2020_06_22_000000_add_introduction_to_form',
        '2020_07_28_000000_change_forms_answers_answer_to_nullable',
        '2020_10_14_000000_change_status_notifications_to_system',
        '2021_04_13_000000_improve_forms', '2021_04_21_000000_delete_old_introduction_field_in_forms',
        '2021_07_08_000000_recreate_admin_roles_field_if_needed', '2021_08_16_000000_add_submission_web_notification',
        '2021_08_23_000000_add_status_notifications_email', '2022_08_04_000000_clean_answers_with_deleted_content_references',
        '2023_02_20_000000_add_submission_edit_informations', '2023_02_20_000000_inside_form_remove_old_notification_types',
        '2023_03_01_000000_add_submission_comment', '2023_03_02_000000_add_submission_status_updated_admin_notification_types',
        '2023_04_11_000000_delete_old_forms_layouts', '2023_05_02_000000_default_form_checkbox_for_advanced_settings',
        '2023_06_14_000000_save_answers_field_type', '2023_06_14_000001_save_date_answers_as_timestamps',
        '2023_11_29_000000_add_code_to_forms_submissions',
    ];

    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        if (! InsideSchema::hasModel('forms')) {
            return;
        }

        $bridgeContent = new BridgeContent();

        Forms::select('uuid')->each(fn ($form) => $bridgeContent->contentDelete('forms', $form->uuid));

        $bridgeContentType->contentTypeDelete('forms');

        collect(self::TABLES_TO_DELETE)->each(function ($table) {
            DB::statement('SET FOREIGN_KEY_CHECKS=0');
            Schema::dropIfExists($table);
            DB::statement('SET FOREIGN_KEY_CHECKS=1');
        });

        LayoutPath::where('path', 'like', 'inside_content_forms%')
            ->pluck('layout_id')
            ->unique()
            ->each(fn (int $layoutId) => app(LayoutRepositoryInterface::class)->delete($layoutId));

        Setting::where('group', 'forms')->where('key', 'show_question_id')->delete();

        collect(self::MIGRATIONS_TO_DELETE)->each(fn ($migration) => DB::table('migrations')->where('migration', 'like', "%{$migration}%")->delete());
    }
}
