<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;

class CreateContentTypeFlashNews extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent(contentType: 'flash_news');
        $this->finishUp();

        Artisan::call("models:rebuild");
    }

    public function down(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDelete('flash_news');
        $this->finishUp();
    }
}
