<?php

return [
    'files' => [
        'feps' => [
            'path' => env("FEPS_USER_PATH", __DIR__ . '/../../../../imports/import.csv'),
            'separator' => ';',
            'fields' => [
                'name' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return trim($record['mail']);
                },
                'mail' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return trim($record['mail']);
                },
                'firstname'   => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return ucwords($record['prénom']);
                },
                'lastname'    => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return ucwords($record['nom']);
                },
                'company' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return trim($record['societe']);
                },
                'function' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return trim($record['fonction']);
                },
                'feps_function' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return trim($record['fonction feps']);
                },
                'phone' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return trim($record['téléphone fixe']);
                },
                'is_maintenance' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return false;
                },
                'status' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return true;
                }
            ]
        ]
    ]
];
