<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Field;
use Inside\Host\Bridge\BridgeContent;

class GiveAllUsersDefaultTools extends Migration
{
    public function up(): void
    {
        /** @var Field $field */
        $field = Field::query()->where('name', 'tools')->first();
        $defaultShortcuts = [];

        if ($field->options) {
            foreach ($field->options['default'] as $uuid_host) {
                $shortcut = Tools::query()->where('uuid_host', $uuid_host)->first();

                if (!$shortcut) {
                    continue;
                }

                $defaultShortcuts[] = $shortcut->uuid;
            }
        }

        $bridge = new BridgeContent();

        // Get users without tools
        $users = Users::query()
            ->whereNotIn(
                'uuid',
                DB::table('inside_pivots')
                ->where('parent_type', 'Inside\Content\Models\Contents\Users')
                ->where('related_type', 'Inside\Content\Models\Contents\Tools')
                ->pluck('parent_uuid')
            )->get();

        foreach ($users as $user) {
            $bridge->contentUpdate('users', [
                'tools' => $defaultShortcuts,
                'uuid' => $user->uuid
            ]);
        }
    }

    public function down(): void
    {
    }
}
