export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    calendarImportEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    gdprContent: 'popins'
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'functions',
        class: 'function',
        data: data => data?.functions?.title
      }
    ]
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-users': {
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () =>
          import('../inside-customs/components/directory/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          { function: ['uuid', 'title'] }
        ]
      }
    }
  }
}
