<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Drupal\node\Entity\NodeType;
use Inside\Content\Facades\Schema;

class FixTranslatableContentForFepl extends Migration
{
    public function up(): void
    {
        $types = [
            "functions",
            "newsletters",
            'assignment',
            'document_library_rights',
        ];

        $bridgeContentType = new BridgeContentType();
        foreach ($types as $type) {
            if (! Schema::hasContentType($type)) {
                continue;
            }

            $bridgeContentType->updateContentTypeOptions(
                type: $type,
                options: [
                    'name' => $type,
                    'translatable' => true
                ]
            );

            $bridgeContentType->contentTypeUpdateOrCreate(
                type: $type,
                options: [
                    'name' => $type,
                    'translatable' => true
                ]
            );
        }

        $bridgeContentType->updateContentTypeOptions(
            type: 'users',
            options: [
                'translatable' => false
            ]
        );

        Artisan::call('models:rebuild');
    }
}
