<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tools_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Catégorie d\'outil',
            'en' => 'Tool category',
            'nl' => 'Categorie gereedschap',
            'pt' => 'Categoria de ferramenta',
            'es' => 'Categoría de herramienta',
            'de' => 'Werkzeugkategorie',
        ],
    ],
    'fields' => [
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Order of appearance',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
                'nl' => 'Het laagste getal gaat naar 1e',
                'pt' => 'O valor mais baixo foi em 1',
                'es' => 'El número más bajo sube en 1er.',
                'de' => 'Die niedrigste Zahl steigt in 1.',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'tools_categories_listings',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Listing d\'outils',
                'en' => 'Tool List',
                'nl' => 'Gereedschapslijst',
                'pt' => 'Lista de ferramentas',
                'es' => 'Lista de herramientas',
                'de' => 'Werkzeugliste',
            ],
            'description' => [
                'fr' => 'Choisissez le listing d\'outils dans lequel cette catégorie doit remonter',
                'en' => 'Choose the tools listing in which this category should go',
                'nl' => 'Kies de toolslijst waarin deze categorie moet komen',
                'pt' => 'Escolha a listagem de ferramentas na qual esta categoria deve ir',
                'es' => 'Elija el listado de herramientas en el que debe ir esta categoría',
                'de' => 'Wählen Sie die Werkzeugliste aus, in die diese Kategorie aufgenommen werden soll',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools_categories_listings'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
