<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/fepl-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/fepl-back/resources/assets/img/newsletter/bg.png',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#EA9675',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'leftLineColor' => '#3D32BB',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#2C3E50'
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#3D32BB',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#F0F0F0',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
