<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateUsersCustomContentTypesForFepl extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('document_library_rights', false);
        $this->migrateContent('assignment', false);
        $this->call('models:rebuild');
        $this->finishUp();

        $bridge = new BridgeContentType();
        $contentTypes = collect([
            'Droit base documentaire' => 'document_library_rights',
            'Délégation' => 'assignment',
        ]);

        $contentTypes->each(function ($contentType) use ($bridge) {
            if (Schema::hasField('users', $contentType)) {
                $bridge->contentTypeDeleteField(
                    entityType: 'user',
                    type: 'user',
                    fieldName: $contentType,
                );
            }
        });

        $contentTypes->each(function ($contentType, $key) use ($bridge) {
            if (Schema::hasContentType($contentType)) {
                $bridge->contentTypeCreateOrUpdateField(
                    type: 'users',
                    fieldName: $contentType,
                    options: [
                        'name' => $contentType,
                        'searchable' => false,
                        'translatable' => true,
                        'search_result_field' => false,
                        'searchable_filter' => false,
                        'required' => false,
                        'weight' => 6,
                        'title' => [
                            'fr' => $key
                        ],
                        'widget' => [
                            'type' => BridgeContentType::SELECT_WIDGET,
                            'settings' => [],
                            'weight' => 7,
                        ],
                        'type' => BridgeContentType::REFERENCE_FIELD,
                        'settings' => [
                            'target_type' => [$contentType],
                            'cardinality' => 1,
                        ],
                    ],
                    weight: 7
                );
            }
        });
    }
}
