import TabsSpacesListingPage from '../pages/tabs-spaces/TabsSpacesListingPage'
import { fetchTabsSpacesListingPage } from '../components/tabs-spaces'

import SpacePage from '../pages/spaces/SpacePage'
import SpacePagesPage from '../pages/spaces/SpacePagesPage'
import { fetchSpace, fetchSpacePagesPage } from '../components/spaces'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'TabsSpacesListingPage',
    path: '/listing-espaces-onglet/:slug',
    component: withFetch(TabsSpacesListingPage, {
      size: 'xxl',
      watch: true
    })(fetchTabsSpacesListingPage)
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: '/espace/:slug'
  },
  {
    name: 'SpacePagesPage',
    path: '/espace/:slug/pages',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpacePagesPage)
  },
  {
    name: 'WallsListingPage',
    meta: { disabled: false, customSlug: 'walls' }
  },
  {
    name: 'WallPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  }
]
