import { markRaw } from 'vue'

import { IconText } from 'inside-collection/atoms'

import { $_formatDate } from '@inside-library/helpers/global-methods/dates'

export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    calendarImportEnabled: true
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-jobs': {
    extraFields: ['published_at', { locations: ['uuid', 'title'] }],
    categoriesFields: [
      {
        contracts_types: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        locations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', [
        {
          id: 'location',
          class: 'location',
          tag: markRaw(IconText),
          data: { icon: 'address' },
          value: data?.locations?.title,
          hideIf: () => !data?.locations
        },
        {
          id: 'publishedAt',
          class: 'publishedAt',
          tag: markRaw(IconText),
          data: { icon: 'calendar' },
          value: $_formatDate(data?.published_at)
        }
      ])
    }
  },
  'inside-news': {
    minimalDate: true
  },
  'inside-users': {
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-workflows': {
    isEnabled: true
  }
}
