import { http } from '@inside-library/helpers/Http'

export default {
  jobsOffers: {
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'job',
          'fetch',
          {
            item: data,
            contentType: data.content_type
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
      }
    })
  },
  spacesCategories: {
    add: ({ data }) => {
      return {
        name: 'TabsSpacesListingPage',
        params: { slug: data.slug[0] }
      }
    }
  },
  spaces: {
    add: async ({ data }) => {
      const { data: space } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: { slug: space[0].slug[0] }
      }
    }
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', 'title', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: { slug: category[0].spaces.slug[0] }
      }
    },
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: Space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePagesPage',
          params: {
            slug: Space[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],

    add: async ({ data }) => {
      const { data: page } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          { pages_categories: [{ spaces: ['uuid', 'title', 'slug'] }] }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePagesPage',
        params: {
          slug: page[0].pages_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get('content/spaces_pages', {
        fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: Space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': pagesCategories[0].pages_categories.uuid }
      })

      return {
        route: {
          name: 'SpacePagesPage',
          params: {
            slug: Space[0].spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
