import imageLinkListing from '../../assets/img/custom-page/imageLinkListing.png'

export const availableComponents = t => [
  {
    component: 'LinkListing',
    label: t(
      'customs.CUSTOM_PAGE.linkListing.label'
    ),
    image: imageLinkListing,
    options: {
      extraFilters: {
        'uuid:in': {
          type: 'selectbox',
          endpoint: 'bloc_image',
          fields: ['uuid', 'title'],
          value: [],
          title: t('customs.CUSTOM_PAGE.linkListing.options.uuidIn.title'),
          help: t('customs.CUSTOM_PAGE.linkListing.options.uuidIn.help')
        }
      }
    },
    layouts: [
      { layout: 2 },
      { layout: 3 },
      { layout: 5, requiredRatio: 3 },
      { layout: 6, requiredRatio: 3 },
      { layout: 7 },
      { layout: 8 },
      { layout: 9, requiredRatio: 2 },
      { layout: 10, requiredRatio: 2 }
    ]
  }
]

export const componentImport = {
  LinkListing: () =>
    import('@inside-customs/components/homepage/LinkListing')
}
