import { http } from '@inside-library/helpers/Http'

export const fetchTabsSpacesListingPage = async ({ $route }) => {
  try {
    const { data: tabsSpaces } = await http.get('content/tabs_spaces', {
      fields: ['uuid', 'admin', 'title', 'content_type', 'slug', 'image'],
      filters: {
        spaces_categories: { 'slug:eq': $route.params.slug },
        sort: 'weight:asc'
      }
    })

    const { data: spacesCategories } = await http.get(
      'content/spaces_categories',
      {
        fields: [
          'uuid',
          'admin',
          'title',
          'content_type',
          'banner',
          'introduction'
        ],
        filters: { 'slug:eq': $route.params.slug }
      }
    )

    return [tabsSpaces, spacesCategories[0]]
  } catch (err) {
    throw new Error(err)
  }
}
