<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddTeamLinksToUsers extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'team_links', [
          'name' => 'team_links',
          'searchable' => true,
          'translatable' => false,
          'search_result_field' => false,
          'searchable_filter' => false,
          'required' => false,
          'weight' => 3,
          'title' => [
            'fr' => 'Teams',
          ],
          'widget' => [
            'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            'settings' => [],
            'weight' => 3,
          ],
          'type' => BridgeContentType::TEXT_FIELD,
          'settings' => [
            'max_length' => 255,
            'is_ascii' => false,
            'case_sensitive' => false,
            'cardinality' => 1,
          ]
        ]);
    }
}
