<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;

class UpdateNotificationsTypesTable extends Migration
{
    public function up(): void
    {
        $notificationTypes = [];

        // [nom de la personne] a aimé votre commentaire
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
              'via' => 'web',
              'default' => true,
              'event' => 'Inside\Reaction\Events\ReactionSubscribedEvent',
              'model' => 'Inside\Content\Models\Contents\Comments',
              'action' => 'like',
              'type' => 'system',
              'condition' => 'author:CURRENT_USER',
              'multiple' => true,
              'profile' => false,
              'data' => [
                'title' => 'notifications.reaction.like.comment.title',
                'text' => 'notifications.reaction.like.comment.text',
                'icon' => 'like',
                'fields' => [
                  'notification-data.from' => ['firstname', 'lastname'],
                ]
              ],
            ]
        );

        // [nom de la personne] a aimé votre actualité [nom de l’actualité]
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
              'via' => 'web',
              'default' => true,
              'event' => 'Inside\Reaction\Events\ReactionSubscribedEvent',
              'model' => null,
              'action' => 'like',
              'type' => 'system',
              'condition' => 'author:CURRENT_USER',
              'multiple' => true,
              'profile' => true,
              'data' => [
                'title' => 'notifications.reaction.like.title',
                'text' => 'notifications.reaction.like.text',
                'icon' => 'like',
                'fields' => [
                  'notification-data.from' => ['firstname', 'lastname'],
                  'title',
                ]
              ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            User::all()->each(function ($user) use ($notificationType) {
                NotificationSubscriber::firstOrCreate([
                  'user_uuid' => $user->uuid,
                  'notification_type_id' => $notificationType->id,
                ]);
            });
        }
    }
}
