<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/fepe-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/fepe-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#4539C8',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionArrowUrl' => 'vendor/maecia/fepe-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#4539C8'
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionArrowUrl'  => 'vendor/maecia/fepe-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#4539C8',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionArrowUrl' => 'vendor/maecia/fepe-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#4539C8'
            ],
        ],
        'new_members' => [
            'sectionTitleStrKey' => 'newsletter.new_members_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'function',
            'types' => ['movements'],
            'fieldLabel' => [
                'movements' => [
                    'fr' => 'Mouvements',
                ],
            ],
            'link' => [
                'sectionLinkUrl' => 'mouvements',
                'sectionArrowUrl' => 'vendor/maecia/fepe-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#4539C8',
                'sectionLinkStrKey' => 'newsletter.see_all_new_members',
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#4539C8',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/',
            ],
            'linkedin' => [
                'url' => 'https://linkedin.com/',
            ],
            'instagram' => [
                'url' => 'https://instagram.com/',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
