<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateJobsOffers extends Migration
{
    use CreateContentTypes;
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'jobs_offers', 'color');
        $bridge->contentTypeCreateOrUpdateField('jobs_offers', 'locations', [
            'name' => 'locations',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Site',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => 1,
            ],
            'selectable_all' => true,
        ], 3);
        $bridge->updateFieldOptions('jobs_offers', 'contracts_types', [
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $this->call('models:rebuild');
        $this->finishUp();
    }
}
