<?php

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'phone' => 'mobilePhone',
        'mobile_phone' => 'mobilePhone',
        'function' => fn (mixed $user) => $user->jobTitle,
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from(ucfirst($user->department))
            ->get(),
        'locations' => fn (mixed $user) => reference('locations')
          ->identifiedBy('code')
          ->from(ucfirst($user->city))
          ->get(),
        'entities' => fn (mixed $user) => reference('entities')
            ->identifiedBy('code')
            ->from(ucfirst($user->companyName))
            ->get(),
        'managers' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->get(),
        'status' => fn () => 1,
        'team_links' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->mail",
    ],
    'custom_attributes' => [
      'manager' => 'mail',
    ],
];
