import SpacesPage from '../pages/spaces/SpacesPage'
import { fetchSpacesPage } from '../fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'InternalNewsListingPage',
    path: '/coin-des-collabs',
    component: () => import('@inside-news/components/pages/ListingPage'),
    props: {
      filters: [],
      contentRoot: {
        collab_corner: item => ({
          name: 'InternalNewsPage',
          params: { slug: item.slug[0] }
        })
      },
      bannerData: {
        add: ['collab_corner']
      }
    },
    meta: { customSlug: 'collab_corner' }
  },
  {
    name: 'InternalNewsPage',
    path: '/coin-des-collabs/:slug',
    component: () => import('@inside-news/components/pages/NewsPage'),
    props: {
      contentType: 'collab_corner',
      fieldsContentType: 'news',
      configModule: 'inside-customs',
      back: { href: { name: 'InternalNewsListingPage' } }
    }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espace/:slug/pages',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage),
    meta: { content: 'spaces' }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/directory/DirectoryPage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'TeamsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
