export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'phone',
      'mobile_phone',
      'image',
      'function',
      { entities: ['uuid', 'title'] },
      'professional_email'
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'created_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  }
}
