import { http } from '@inside-library/helpers/Http'

import { ROUTE_NAMES } from '../constants'

export default {
  collabCorner: {
    add: ({ data }) => ({
      name: ROUTE_NAMES.page,
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: ROUTE_NAMES.listing })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { spaces_tabs: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces_tabs.spaces.slug[0] },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces_tabs.spaces.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: spacesTabs } = await http.get('content/spaces_pages', {
        fields: ['uuid', { spaces_tabs: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: spaces } = await http.get('content/spaces_tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': spacesTabs[0].spaces_tabs.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spaces[0].spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  spacesTabs: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces_tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spaces[0].spaces.slug[0]
          }
        }
      }
    }
  }
}
