import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-customs': {
    templates: {
      fullContent: {
        collabCorner: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    csvImport: true,
    shortcuts: {
      max: 6
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/directory/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'thumbnail')
        }),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'function',
          'entities',
          'image'
        ]
      }
    }
  }
}
