<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\InternalNews;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class CreateAndManageComInterneCategoryContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('internal_com_categories');
        $this->finishUp();

        $contentTypeBridge = new BridgeContentType();

        Artisan::call('models:rebuild');

        // create field com'interne category in the content type com'interrne
        $contentTypeBridge->contentTypeCreateOrUpdateField(
            'internal_news',
            'internal_com_categories',
            [
                'name' => 'internal_com_categories',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Com\Interne Categories',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['internal_com_categories'],
                    'cardinality' => 1,
                ],
                'selectable_all' => false,
            ]
        );

        $contentBridge = new BridgeContent();

        // creating com'intern category content
        $newInternaComCategoryUuid = $contentBridge->contentInsert('internal_com_categories', [
            'title' => 'Com interne',
        ]);

        // update all the com'internes fields com interne category with the newly created com interne category
        InternalNews::select('uuid')->get()->each(function ($internalNews) use ($contentBridge, $newInternaComCategoryUuid) {
            $contentBridge->contentUpdate('internal_news', [
                'uuid' => $internalNews->uuid,
                'internal_com_categories' => $newInternaComCategoryUuid,
            ]);
        });
    }
}
