<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class DeleteEmptyEmailUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        Users::query()
            ->where('email', '')
            ->orWhereNull('email')
            ->pluck('uuid')
            ->each(fn (string $uuid) => $bridge->contentDelete('users', $uuid));
    }
}
