<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

return [
    'files' => [
        'fass' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => ';',
            'fields' => [
                'name' => 'mail',
                'mail' => 'mail',
                'firstname' => fn ($record) => ucwords($record['prénom']),
                'lastname' => fn ($record) => ucwords($record['nom']),
                'status' => fn () => 1,
                'is_maintenance' => fn () => false,
                'function' => fn ($record) => trim($record['fonction']) ?: null,
                'phone' => fn ($record) => trim($record['téléphone']) ?: null,
                'professional_email' => fn ($record) => trim($record['mail professionnel']) ?: null,
                'mobile_phone' => fn ($record) => trim($record['mobile']) ?: null,
                'entities' => fn (array $record) => reference('entities')
                    ->identifiedBy('title')
                    ->from($record['entité'])
                    ->get()
            ],
            'original_fields' => [
                'mail' => 'mail',
                'prénom' => 'firstname',
                'nom' => 'lastname',
                'fonction' => 'function',
                'téléphone' => 'word',
                'mail professionnel' => 'word',
                'mobile' => 'word',
                'entité' => 'word',
            ]
        ],
    ],
];
