<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\InternalNews;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class RemoveCominternsManageNewsCategories extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('news_categories');
        $this->migrateContent('collab_corner');
        $this->finishUp();

        $contentBridge = new BridgeContent();

        InternalNews::get()->each(function ($news) use ($contentBridge) {
            $contentBridge->contentInsert('news', [
                'title' => $news->title,
                'comments' => $news->comments,
                'content' => $news->content,
                'image' => $news->image,
                'chapo' => $news->chapo,
            ]);
        });

        Artisan::call('models:rebuild');

        $contentTypeBridge = new BridgeContentType();

        $contentTypeBridge->contentTypeDelete('internal_news');

        $contentTypeBridge->contentTypeCreateOrUpdateField(
            'news',
            'news_categories',
            [
                'name' => 'news_categories',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Catégories',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news_categories'],
                    'cardinality' => 1,
                ],
                'selectable_all' => false,
            ]
        );
    }
}
