<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Entities;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddEntitiesHomepage extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            'entities',
            'homepage',
            [
                'name' => 'homepage',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => "Afficher sur la Page d'acdeuil",
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
        );

        $bridgeContent = new BridgeContent();
        Entities::query()
            ->whereIn('title', ['Decauville', 'Miltra Paris Nord', 'Miltra Provence', 'Fassi France'])
            ->each(function (Entities $entity) use ($bridgeContent) {
                $bridgeContent->contentUpdate(
                    $entity->content_type,
                    [
                        'uuid' => $entity->uuid,
                        'homepage' => true,
                    ],
                );
            });

        $this->finishUp();
    }
}
