<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class CreateCustoms extends Migration
{
    public function up(): void
    {
        $customs = [
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => 'ACTUALITÉS',
            ],
            [
                'custom_slug' => 'internal-news',
                'redirection_page' => 'InternalNewsListingPage',
                'title' => "COM' INTERNE",
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => 'ÉVÈNEMENTS',
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => 'ANNUAIRE',
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => 'Ressources',
                'introduction' => 'Retrouvez tous les documents, photos, fiches pratiques…',
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => 'OUTILS',
            ],
            [
                'custom_slug' => 'groups',
                'redirection_page' => 'TeamsListingPage',
                'title' => 'Groupes collaboratifs',
                'introduction' => "Ces espaces vous permettent de collaborer par communautés. N'hésitez pas à proposer la création d'un groupe !",
            ],
            [
                'custom_slug' => 'organizational-charts',
                'redirection_page' => 'OrganizationsListingPage',
                'title' => 'ORGANIGRAMMES',
            ],
        ];

        $bridge = new BridgeContent();

        foreach ($customs as $custom) {
            $uuid = Custom::query()
                ->where('custom_slug', $custom['custom_slug'])
                ->first()
                ?->uuid;

            if ($uuid) {
                $custom['uuid'] = $uuid;
            }

            $bridge->contentInsert('custom', $custom, $uuid === null);
        }
    }
}
