export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-customs': {
    templates: {
      fullContent: {
        strategies: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  },
  'inside-events': {
    bookmarkEnabled: true,
    showBookmarks: true,
    subscriptionEnabled: true,
    extraCategoriesFilters: ['sites']
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-news': {
    bookmarkEnabled: true,
    extraCategoriesFilters: ['sites']
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/Card'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          { services: ['uuid', 'title'] },
          { locations: ['uuid', 'title'] },
          { entities: ['uuid', 'title'] }
        ]
      }
    },
    shortcuts: {
      readonlyCount: 3
    }
  },
  'inside-workflows': {
    isEnabled: true
  }
}
