export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'function',
      'email',
      'image',
      'phone',
      'switchboard_phone',
      { locations: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { cities: ['uuid', 'title'] },
      {
        manager: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          { services: ['uuid', 'title'] },
          { locations: ['uuid', 'title'] }
        ]
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  business_sheets: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'file',
      'image',
      { business_sheet_folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  markers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'covered_area',
      'phone',
      'image',
      'address',
      { regions: ['uuid', 'title'] }
    ]
  }
}
