import SpacePage from '../pages/spaces/SpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'

import { fetchSpace } from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    props: {
      extraFields: [{ sites: ['uuid', 'title'] }],
      contentOptions: {
        extraCategoriesConfig: {
          sites: {
            data: (data, contentType, { getData }) =>
              getData(data, contentType),
            href: ({ uuid }) => ({
              name: 'NewsListingPage',
              query: { sites: uuid }
            })
          }
        }
      },
      relatedOptions: {
        extraFields: [{ sites: ['title', 'uuid'] }],
        componentAttributes: () => ({
          extraCategoriesConfig: {
            sites: {
              data: (data, contentType, { getData }) =>
                getData(data, contentType),
              disabledOn: ['NewsListingPage'],
              href: ({ uuid }) => ({
                name: 'NewsListingPage',
                query: { sites: uuid }
              })
            }
          }
        })
      }
    }
  },
  {
    name: 'StrategiesListingPage',
    component: () => import('../pages/strategies/StrategiesListingPage'),
    path: {
      fr: '/strategie-entreprise',
      en: '/corporate-strategy'
    }
  },
  {
    name: 'StrategyPage',
    component: () => import('../pages/strategies/StrategyPage'),
    path: {
      fr: '/strategie-entreprise/:slug',
      en: '/corporate-strategy/:slug'
    }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      homeWithCards: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          'archived:eq': 0,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'BusinessSheetsGedPage',
    component: () => import('../pages/ged/BusinessSheetsGedPage'),
    path: {
      fr: 'fiches-metiers',
      en: 'business-sheets'
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/users/DirectoryPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'WallsListingPage',
    meta: { disabled: false, customSlug: 'walls' }
  },
  {
    name: 'WallPage',
    meta: { disabled: false, content: 'walls' }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: {
      fr: '/espaces/:slug',
      en: '/spaces/:slug'
    },
    meta: { content: 'spaces' }
  },
  {
    name: 'TabSpacePage',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchSpace
    ),
    path: {
      fr: '/espaces/pages/:slug',
      en: '/spaces/pages/:slug'
    },
    alias: ['/fr/espaces/:slug/pages', '/en/spaces/:slug/pages'],
    meta: { content: 'spaces' }
  },
  {
    name: 'AdminStatisticsGeneralPage',
    meta: { admin: true, display: true, disabled: true }
  },
  {
    name: 'AdminStatisticsDetailedPage',
    meta: { admin: true, display: true, disabled: false }
  }
]
