import { http } from '@inside-library/helpers/Http'

export default {
  services: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  locations: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  entities: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  strategies: {
    add: ({ data }) => ({
      name: 'StrategyPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'StrategiesListingPage'
    })
  },
  strategyCategories: {
    add: () => ({
      name: 'StrategiesListingPage'
    }),
    delete: () => ({
      name: 'StrategiesListingPage'
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: spacesPages[0].pages_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  businessSheetFolders: {
    add: async ({ fields }) => {
      return {
        name: 'BusinessSheetsGedPage',
        query: {
          folder: fields.uuid
        }
      }
    },
    delete: () => ({
      name: 'BusinessSheetsGedPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  businessSheets: {
    add: async ({ fields }) => {
      if (fields.business_sheet_folders) {
        return {
          name: 'BusinessSheetsGedPage',
          query: {
            folder: fields.business_sheet_folders
          }
        }
      } else {
        return { name: 'BusinessSheetsGedPage' }
      }
    },
    delete: () => ({
      name: 'BusinessSheetsGedPage'
    }),
    globalSearch: ({ data, vm }) => ({
      action: () =>
        vm.triggerModal(
          'doc-ged',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
    })
  },
  businessSheetLinks: {
    add: ({ fields }) => {
      if (fields.business_sheet_folders) {
        return {
          name: 'BusinessSheetsGedPage',
          query: {
            folder: fields.business_sheet_folders
          }
        }
      } else {
        return { name: 'BusinessSheetsGedPage' }
      }
    },
    delete: () => ({
      name: 'BusinessSheetsGedPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  }
}
